<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Speech extends Model 
{

    protected $table = 'speeches';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function dirctor()
    {
        return $this->belongsTo('Director');
    }

    public function images()
    {
        return $this->morphMany('Image');
    }

}